%% Solmech 2026 One-page abstract style definitions
%%
%% based on Solmech 2010-2024 styles 
%%
%% Copyright (C) 2026 by IPPT PAN

\NeedsTeXFormat{LaTeX2e}


%% 10pt, 12pt and twocolumn options are disabled.    
\DeclareOption{10pt}{\OptionNotUsed}
\DeclareOption{12pt}{\OptionNotUsed}
\DeclareOption{twocolumn}{\OptionNotUsed}


%% documentclass
\def\@@ptsize{11pt}
\DeclareOption{11pt}{\def\@@ptsize{11pt}}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ProcessOptions\relax
\LoadClass[\@@ptsize,a4paper,oneside,onecolumn,final]{article}

%% packages
\RequirePackage[T1]{fontenc}
\RequirePackage[english]{babel}
\RequirePackage[centering,top=30mm,bottom=20mm,left=20mm,right=20mm]{geometry}
\RequirePackage{times}
\RequirePackage{graphicx}
\RequirePackage{pslatex}
\RequirePackage{calc}
\RequirePackage{indentfirst}

\ProcessOptions\relax

%\RequirePackage{setspace}
%\singlespacing
 
\setlength{\textfloatsep}{12pt}
\setlength{\abovedisplayskip}{6pt}
\setlength{\belowdisplayskip}{6pt}
\setlength{\parindent}{0mm}
\setlength{\parskip}{3mm}
\setlength{\abovecaptionskip}{6pt}
\setlength{\belowcaptionskip}{6pt}
\setlength{\itemsep}{0pt}

\pagenumbering{gobble} %% Removing page numbers

%% Header definition
\renewcommand{\maketitle}{%
 \newpage
 \thispagestyle{plain}
 \begin{minipage}[t][1cm][t]{\textwidth}%{15.5cm}
  \begin{flushright}
   %\scriptsize
   \fontsize{9}{10}
	\vspace{-60pt}
 \textsf {44th Solid Mechanics Conference: SolMech 2026, September 7--10, 2026, Krak\'{o}w, Poland}
  \end{flushright}
 \end{minipage}
%% Title definition
 \begin{center}%
 	\vspace{-55pt}%
  {%3
   \fontsize{14}{14}\selectfont
   \bfseries
    {\@title}
   \par
  }%3
  %\vspace{18pt}%
 \vspace{6pt}%
  {%4
\fontsize{11}{12}\selectfont
   \bfseries\@author
   \par
  }%4
  %\vspace{14pt}%
  \vspace{5pt}%
  {%5
\fontsize{11}{12}\selectfont
   %\def\and{\\\vspace{14pt}}
\def\and{\\\vspace{13pt}}
   \normalfont\@address
   \par
  }%5
 \end{center}
 \vspace{-12pt}%
 %\vspace{11pt}%
 %\noindent\textbf{Key words:\space}\@keywords
 %\par
 %\vspace{18pt}%
 %\vspace{12pt}%
 %\noindent\textbf{Abstract.\space}{\textrm\@abstract}
 %\par
%\vspace{18pt}%
 %\vfill
 %\newpage
}% End of \@maketitle

\def\author{\@ifnextchar[{\@getshortauthor}{\@getauthor}}
\def\@getauthor#1{\gdef\@author{#1}\gdef\@shortauthor{#1}}
\def\@getshortauthor[#1]#2{\gdef\@shortauthor{#1}\gdef\@author{#2}}

\newcommand{\address}[1]{\gdef\@address{#1}}

\newcommand{\keywords}[1]{\gdef\@keywords{#1}}

\renewcommand{\abstract}[1]{\gdef\@abstract{#1}}

\newcommand{\heading}[1]{\gdef\@heading{#1}}

\renewcommand{\@makecaption}[2]{%
  \vskip\abovecaptionskip
  \sbox\@tempboxa{\normalsize\fontsize{10}{12}\selectfont {#1}. #2}%
  \ifdim \wd\@tempboxa >\hsize
    \normalsize\fontsize{10}{12}\selectfont {\bf #1}: #2\par
  \else
    \global \@minipagefalse
    \hb@xt@\hsize{\hfil\box\@tempboxa\hfil}%
  \fi
  \vskip\belowcaptionskip}

%% doi definition 
\newcommand{\doi}[1]{\href{https://doi.org/#1}{https://doi.org/#1}}

\renewenvironment{thebibliography}[1]
  {\list{\@biblabel{\@arabic\c@enumiv}}%
        {\settowidth\labelwidth{\@biblabel{#1}}%
			\topsep0pt\parsep0pt\itemsep3pt plus 1pt%\labelsep1mm\leftmargin7mm\labelwidth6mm
         \leftmargin\labelwidth
         %\advance\leftmargin\labelsep
         \advance\leftmargin\labelsep\topsep \z@ \parsep 0pt plus .1pt
         \@openbib@code
         \usecounter{enumiv}%
         \let\p@enumiv\@empty
         \renewcommand\theenumiv{\@arabic\c@enumiv}}%
   \sloppy
   \clubpenalty4000
   \@clubpenalty \clubpenalty
   \widowpenalty4000%
   \sfcode`\.\@m}
  {\def\@noitemerr
   {\@latex@warning{Empty `thebibliography' environment}}%
   \endlist}
   
%% \maketitle make the first page automatically     
\AtBeginDocument{%
  \pagestyle{myheadings}
  \maketitle
  \let\maketitle\relax
}

\endinput
